/**
 * 
 */
package com.ejie.ab18a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aEstadoTramitacion;
import com.ejie.ab18a.utils.Utilidades;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * @author XXXX
 * 
 */
@Repository()
@Transactional()
public class Ab18aEstadoTramitacionDaoImpl implements Ab18aEstadoTramitacionDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aEstadoTramitacion> rwMap = new RowMapper<Ab18aEstadoTramitacion>() {
		public Ab18aEstadoTramitacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEstadoTramitacion(resultSet.getInt("T15IDESTADOTRAMITACION"), resultSet.getString("T15CODESTADOTRAMITACION"),
					resultSet.getString("T15DESCESTADOTRAMITACION"));
		}
	};

	private RowMapper<Ab18aEstadoTramitacion> rwMapCompleto = new RowMapper<Ab18aEstadoTramitacion>() {
		public Ab18aEstadoTramitacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEstadoTramitacion(resultSet.getInt("T15IDESTADOTRAMITACION"), resultSet.getString("T15CODESTADOTRAMITACION"),
					resultSet.getString("T15DESCESTADOTRAMITACION"), resultSet.getString("T15DESCESTADOTRAMITACIONEU"), resultSet.getInt("T15ORDEN"));
		}
	};

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab18a.dao.Ab18aEstadoTramitacionDao#find(com.ejie.ab18a.model
	 * .Ab18aEstadoTramitacion)
	 */
	@Transactional(readOnly = true)
	public Ab18aEstadoTramitacion find(Ab18aEstadoTramitacion estadoTramitacion) {
		String query = "SELECT T15_ID_ESTADO_TRAMITACION T15IDESTADOTRAMITACION, T15_COD_ESTADO_TRAMITACION T15CODESTADOTRAMITACION, T15_DESC_ESTADO_TRAMITACION T15DESCESTADOTRAMITACION FROM AB18A15S00 WHERE T15_ID_ESTADO_TRAMITACION = ?";

		List<Ab18aEstadoTramitacion> estadoTramitacionList = this.jdbcTemplate.query(query, this.rwMap, estadoTramitacion.getIdEstadoTramitacion());
		return (Ab18aEstadoTramitacion) DataAccessUtils.uniqueResult(estadoTramitacionList);
	}

	/**
	 * Finds a list of rows in the Ab18a06s00 table.
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a06s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aEstadoTramitacion> findAll(Ab18aEstadoTramitacion ab18a15s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T15_ID_ESTADO_TRAMITACION T15IDESTADOTRAMITACION,t1.T15_COD_ESTADO_TRAMITACION T15CODESTADOTRAMITACION,t1.T15_DESC_ESTADO_TRAMITACION T15DESCESTADOTRAMITACION ");
		query.append("FROM AB18A15S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a15s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEstadoTramitacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Ab18aEstadoTramitacion> findAllMonitor(Ab18aEstadoTramitacion ab18a15s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T15_ID_ESTADO_TRAMITACION T15IDESTADOTRAMITACION,t1.T15_COD_ESTADO_TRAMITACION T15CODESTADOTRAMITACION,t1.T15_DESC_ESTADO_TRAMITACION T15DESCESTADOTRAMITACION, t1.T15_DESC_ESTADO_TRAMITACION_EU T15DESCESTADOTRAMITACIONEU, t1.T15_ORDEN T15ORDEN ");
		query.append("FROM AB18A15S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a15s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.T15_ID_ESTADO_TRAMITACION IN (1,5)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEstadoTramitacion>) this.jdbcTemplate.query(query.toString(), this.rwMapCompleto, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a06s00 entity
	 * 
	 * @param ab18a06s00
	 *            Ab18a06s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aEstadoTramitacion ab18a15s00) {

		StringBuilder where = new StringBuilder(Ab18aEstadoTramitacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Utilidades.notNullAndNotZero(ab18a15s00.getIdEstadoTramitacion())) {
			where.append(" AND t1.T15_ID_ESTADO_TRAMITACION = ?");
			params.add(ab18a15s00.getIdEstadoTramitacion());
		}
		if (Utilidades.notNullAndNotEmpty(ab18a15s00.getCodEstadoTramitacion())) {
			where.append(" AND t1.T15_COD_ESTADO_TRAMITACION = ?");
			params.add(ab18a15s00.getCodEstadoTramitacion());
		}
		if (Utilidades.notNullAndNotEmpty(ab18a15s00.getDescEstadoTramitacion())) {
			where.append(" AND UPPER(t1.T15_DESC_ESTADO_TRAMITACION) like ? ESCAPE  '\\'");
			params.add("%" + ab18a15s00.getDescEstadoTramitacion().toUpperCase() + "%");
			where.append(" AND t1.T15_DESC_ESTADO_TRAMITACION IS NOT NULL");
		}

		where.append(" ORDER BY T15_ORDEN ASC");

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * @param secuencia
	 *            String
	 * @return String
	 * @throws Exception
	 *             the exception
	 */
	public int getNextSequenceValue(String secuencia) throws Exception {
		Integer sequenceValue = -1;
		try {
			String query = "SELECT " + secuencia + ".NEXTVAL FROM DUAL";
			sequenceValue = this.jdbcTemplate.queryForInt(query);
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}
		return sequenceValue;
	}

	@Transactional(rollbackFor = Throwable.class)
	public Ab18aEstadoTramitacion update(Ab18aEstadoTramitacion mantenimiento) {
		String query = "UPDATE AB18A15S00 SET T15_COD_ESTADO_TRAMITACION=?, T15_DESC_ESTADO_TRAMITACION=? WHERE T15_ID_ESTADO_TRAMITACION=?";
		this.jdbcTemplate.update(query, mantenimiento.getCodEstadoTramitacion(), mantenimiento.getDescEstadoTramitacion(),
				mantenimiento.getIdEstadoTramitacion());
		return mantenimiento;
	}

	@Transactional(rollbackFor = Throwable.class)
	public Ab18aEstadoTramitacion add(Ab18aEstadoTramitacion mantenimiento) throws DataAccessException, Exception {
		String query = "INSERT INTO AB18A15S00 (T15_ID_ESTADO_TRAMITACION, T15_COD_ESTADO_TRAMITACION, T15_DESC_ESTADO_TRAMITACION) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, this.getNextSequenceValue("SQAB18A15"), mantenimiento.getCodEstadoTramitacion(),
				mantenimiento.getDescEstadoTramitacion());
		return mantenimiento;
	}

	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aEstadoTramitacion estadoFiltro) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A15S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(estadoFiltro);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
